﻿IF OBJECT_ID(N'[PA_MIGRATION_HISTORY]') IS NULL
BEGIN
    CREATE TABLE [PA_MIGRATION_HISTORY] (
        [MH_ID] nvarchar(150) NOT NULL,
        [MH_EF_VERSION] nvarchar(32) NOT NULL,
        CONSTRAINT [PK_PA_MIGRATION_HISTORY] PRIMARY KEY ([MH_ID])
    );
END;
GO

BEGIN TRANSACTION;
GO

CREATE TABLE [PA_CONFIGURATION] (
    [CFG_ID] int NOT NULL IDENTITY,
    [CFG_KEY] nvarchar(440) NULL,
    [CFG_VALUE] sql_variant NULL,
    CONSTRAINT [PK_PA_CONFIGURATION] PRIMARY KEY ([CFG_ID])
);
GO

CREATE TABLE [PA_ROLE] (
    [ROL_ID] int NOT NULL IDENTITY,
    [ROL_NAME] nvarchar(255) NULL,
    [ROL_FLAGS] int NULL,
    CONSTRAINT [PK_PA_ROLE] PRIMARY KEY ([ROL_ID])
);
GO

CREATE TABLE [PA_USER] (
    [USR_ID] int NOT NULL IDENTITY,
    [USR_LOGON_NAME] nvarchar(440) NULL,
    [USR_PASSWORD_HASH] nvarchar(255) NULL,
    [USR_EMAIL] nvarchar(max) NULL,
    [USR_DESCRIPTION] nvarchar(max) NULL,
    [USR_FULL_NAME] nvarchar(max) NULL,
    [USR_FLAGS] int NULL,
    [USR_LAST_LOGIN_DATE] datetime NULL,
    [USR_LOGIN_ATTEMPTS_COUNT] int NULL,
    [USR_BLOCKED_DATE] datetime NULL,
    CONSTRAINT [PK_PA_USER] PRIMARY KEY ([USR_ID])
);
GO

CREATE TABLE [PA_ROLE_PERMISSION] (
    [ROP_ID] int NOT NULL IDENTITY,
    [ROP_ROLE_ID] int NOT NULL,
    [ROP_PERMISSION_ID] int NOT NULL,
    CONSTRAINT [PK_PA_ROLE_PERMISSION] PRIMARY KEY ([ROP_ID]),
    CONSTRAINT [PA_PA_ROLE_PERMISSION_ROLE] FOREIGN KEY ([ROP_ROLE_ID]) REFERENCES [PA_ROLE] ([ROL_ID])
);
GO

CREATE TABLE [PA_OPERATION_STATUS] (
    [OPE_ID] bigint NOT NULL IDENTITY,
    [OPE_NAME] ntext NULL,
    [OPE_SESSION_ID] uniqueidentifier NULL,
    [OPE_REQUEST_ID] nvarchar(max) NULL,
    [OPE_VIEW_ID] bigint NULL,
    [OPE_MODEL_ID] bigint NULL,
    [OPE_USER_ID] int NULL,
    [OPE_FLAGS] int NULL,
    [OPE_START_TIME] datetime NULL,
    [OPE_END_TIME] datetime NULL,
    [OPE_MESSAGE] nvarchar(max) NULL,
    [OPE_ADDITIONAL_DATA] nvarchar(max) NULL,
    [OPE_PARAMETERS] nvarchar(max) NULL,
    [OPE_LAST_POLLING_TIME] datetime NULL,
    CONSTRAINT [PK_PA_OPERATION_STATUS] PRIMARY KEY ([OPE_ID]),
    CONSTRAINT [PA_OPERATION_STATUS_USER] FOREIGN KEY ([OPE_USER_ID]) REFERENCES [PA_USER] ([USR_ID])
);
GO

CREATE TABLE [PA_PROJECT] (
    [PRO_ID] bigint NOT NULL IDENTITY,
    [PRO_PARENT_ID] bigint NULL,
    [PRO_NAME] nvarchar(440) NULL,
    [PRO_DESCRIPTION] nvarchar(max) NULL,
    [PRO_CREATED_DATE] datetime NULL,
    [PRO_CREATED_BY] int NULL,
    [PRO_LAST_MODIFIED_DATE] datetime NULL,
    [PRO_LAST_MODIFIED_BY] int NULL,
    [PRO_DELETED_DATE] datetime NULL,
    [PRO_DELETED_BY] int NULL,
    [PRO_FLAGS] int NULL,
    [PRO_CONFIGURATION] nvarchar(max) NULL,
    CONSTRAINT [PK_PA_PROJECT] PRIMARY KEY ([PRO_ID]),
    CONSTRAINT [PA_PROJECT_CREATED_BY] FOREIGN KEY ([PRO_CREATED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_PROJECT_DELETED_BY] FOREIGN KEY ([PRO_DELETED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_PROJECT_LAST_MODIFIED_BY] FOREIGN KEY ([PRO_LAST_MODIFIED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_PROJECT_PARENT_ID] FOREIGN KEY ([PRO_PARENT_ID]) REFERENCES [PA_PROJECT] ([PRO_ID])
);
GO

CREATE TABLE [PA_SCRIPT_LOG] (
    [SCL_ID] bigint NOT NULL IDENTITY,
    [SCL_SCRIPT_ID] bigint NULL,
    [SCL_TYPE] int NULL,
    [SCL_FLAGS] int NULL,
    [SCL_START_TIME] datetime NULL,
    [SCL_END_TIME] datetime NULL,
    [SCL_USER_ID] int NULL,
    [SCL_RESULT] nvarchar(max) NULL,
    [SCL_LOG] nvarchar(max) NULL,
    [SCL_ADDITIONAL_DATA] nvarchar(max) NULL,
    [SCL_OPERATION_ID] bigint NULL,
    CONSTRAINT [PK_PA_SCRIPT_LOG] PRIMARY KEY ([SCL_ID]),
    CONSTRAINT [PA_SCRIPT_LOG_USER_ID] FOREIGN KEY ([SCL_USER_ID]) REFERENCES [PA_USER] ([USR_ID])
);
GO

CREATE TABLE [PA_SESSION] (
    [SES_ID] bigint NOT NULL IDENTITY,
    [SES_SESSION_ID] uniqueidentifier NOT NULL DEFAULT (NEWID()),
    [SES_CREATED_DATE] datetime NULL,
    [SES_FINISHED_DATE] datetime NULL,
    [SES_LAST_ACCESS] datetime NULL,
    [SES_USER_ID] int NULL,
    [SES_USER_LOGON_NAME] nvarchar(440) NULL,
    [SES_USER_IP_ADDRESS] nvarchar(max) NULL,
    [SES_FLAGS] int NULL,
    [SES_CLIENT_VERSION] nvarchar(max) NULL,
    [SES_SERVER_VERSION] nvarchar(max) NULL,
    [SES_ADDITIONAL_DATA] nvarchar(max) NULL,
    [SES_AUTHENTICATION_METHOD] int NULL,
    CONSTRAINT [PK_PA_SESSION] PRIMARY KEY ([SES_ID]),
    CONSTRAINT [PA_SESSION_USER] FOREIGN KEY ([SES_USER_ID]) REFERENCES [PA_USER] ([USR_ID])
);
GO

CREATE TABLE [PA_USER_GROUP] (
    [USG_ID] bigint NOT NULL IDENTITY,
    [USG_GROUP_ID] int NULL,
    [USG_MEMBER_ID] int NULL,
    [USG_ROLE_ID] int NULL,
    CONSTRAINT [PK_PA_USER_GROUP] PRIMARY KEY ([USG_ID]),
    CONSTRAINT [PA_USER_GROUP_GROUP] FOREIGN KEY ([USG_GROUP_ID]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_USER_GROUP_MEMBER] FOREIGN KEY ([USG_MEMBER_ID]) REFERENCES [PA_USER] ([USR_ID])
);
GO

CREATE TABLE [PA_INTEGRATION_TABLE] (
    [ITA_ID] bigint NOT NULL IDENTITY,
    [ITA_PROJECT_ID] bigint NOT NULL,
    [ITA_NAME] nvarchar(440) NULL,
    [ITA_DESCRIPTION] nvarchar(max) NULL,
    [ITA_CONFIGURATION] nvarchar(max) NULL,
    [ITA_FLAGS] int NULL,
    [ITA_CREATED_DATE] datetime NULL,
    [ITA_CREATED_BY] int NULL,
    [ITA_LAST_MODIFIED_DATE] datetime NULL,
    [ITA_LAST_MODIFIED_BY] int NULL,
    [ITA_LAST_IMPORT_DATE] datetime NULL,
    [ITA_LAST_IMPORT_BY] int NULL,
    [ITA_LAST_CHANGE_COMMIT_DATE] datetime NULL,
    [ITA_LAST_CHANGE_COMMIT_TOKEN] nvarchar(40) NULL,
    [ITA_LOG] nvarchar(max) NULL,
    [ITA_MAX_NUM_COLUMNS] bigint NULL,
    [ITA_MAX_NUM_ROWS] bigint NULL,
    [ITA_NUM_ROWS] bigint NULL,
    CONSTRAINT [PK_PA_INTEGRATION_TABLE] PRIMARY KEY ([ITA_ID]),
    CONSTRAINT [PA_INTEGRATION_TABLE_CREATED_BY] FOREIGN KEY ([ITA_CREATED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_INTEGRATION_TABLE_LAST_IMPORT_BY] FOREIGN KEY ([ITA_LAST_IMPORT_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_INTEGRATION_TABLE_LAST_MODIFIED_BY] FOREIGN KEY ([ITA_LAST_MODIFIED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_INTEGRATION_TABLE_PROJECT] FOREIGN KEY ([ITA_PROJECT_ID]) REFERENCES [PA_PROJECT] ([PRO_ID])
);
GO

CREATE TABLE [PA_KEY_VALUE_STORE] (
    [KVS_ID] bigint NOT NULL IDENTITY,
    [KVS_TYPE] int NULL,
    [KVS_PROJECT_ID] bigint NULL,
    [KVS_KEY] nvarchar(440) NULL,
    [KVS_VALUE] nvarchar(max) NULL,
    CONSTRAINT [PK_PA_KEY_VALUE_STORE] PRIMARY KEY ([KVS_ID]),
    CONSTRAINT [PA_KEY_VALUE_STORE_PROJECT] FOREIGN KEY ([KVS_PROJECT_ID]) REFERENCES [PA_PROJECT] ([PRO_ID])
);
GO

CREATE TABLE [PA_MODEL] (
    [MOD_ID] bigint NOT NULL IDENTITY,
    [MOD_PROJECT_ID] bigint NULL,
    [MOD_NAME] nvarchar(440) NULL,
    [MOD_DESCRIPTION] nvarchar(max) NULL,
    [MOD_CREATED_DATE] datetime NULL,
    [MOD_CREATED_BY] int NULL,
    [MOD_LAST_MODIFIED_DATE] datetime NULL,
    [MOD_LAST_MODIFIED_BY] int NULL,
    [MOD_LAST_IMPORT_DATE] datetime NULL,
    [MOD_LAST_IMPORT_BY] int NULL,
    [MOD_ARCHIVED_DATE] datetime NULL,
    [MOD_ARCHIVED_BY] int NULL,
    [MOD_FLAGS] int NULL,
    [MOD_NUM_EVENTS] bigint NULL,
    [MOD_NUM_ACTIVITIES] bigint NULL,
    [MOD_NUM_CASES] bigint NULL,
    [MOD_NUM_EVENT_ATTRIBUTE_TYPES] bigint NULL,
    [MOD_NUM_CASE_ATTRIBUTE_TYPES] bigint NULL,
    [MOD_CONFIGURATION] nvarchar(max) NULL,
    CONSTRAINT [PK_PA_MODEL] PRIMARY KEY ([MOD_ID]),
    CONSTRAINT [PA_MODEL_CREATED_BY] FOREIGN KEY ([MOD_CREATED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_MODEL_LAST_MODIFIED_BY] FOREIGN KEY ([MOD_LAST_MODIFIED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_MODEL_PROJECT] FOREIGN KEY ([MOD_PROJECT_ID]) REFERENCES [PA_PROJECT] ([PRO_ID])
);
GO

CREATE TABLE [PA_SCRIPT] (
    [SCR_ID] bigint NOT NULL IDENTITY,
    [SCR_PROJECT_ID] bigint NULL,
    [SCR_USER_ID] int NULL,
    [SCR_CREATED_DATE] datetime NULL,
    [SCR_CREATED_BY] int NULL,
    [SCR_LAST_MODIFIED_DATE] datetime NULL,
    [SCR_LAST_MODIFIED_BY] int NULL,
    [SCR_TITLE] nvarchar(440) NULL,
    [SCR_TEXT] nvarchar(max) NULL,
    [SCR_DESCRIPTION] nvarchar(max) NULL,
    [SCR_FLAGS] int NULL,
    [SCR_LANGUAGE] int NULL,
    CONSTRAINT [PK_PA_SCRIPT] PRIMARY KEY ([SCR_ID]),
    CONSTRAINT [PA_SCRIPT_CREATED_BY] FOREIGN KEY ([SCR_CREATED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_SCRIPT_LAST_MODIFIED_BY] FOREIGN KEY ([SCR_LAST_MODIFIED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_SCRIPT_PROJECT] FOREIGN KEY ([SCR_PROJECT_ID]) REFERENCES [PA_PROJECT] ([PRO_ID])
);
GO

CREATE TABLE [PA_UI_ELEMENT] (
    [UIE_ID] bigint NOT NULL IDENTITY,
    [UIE_IDENTIFIER] nvarchar(max) NULL,
    [UIE_PROJECT_ID] bigint NULL,
    [UIE_CREATED_DATE] datetime NULL,
    [UIE_CREATED_BY] int NULL,
    [UIE_LAST_MODIFIED_DATE] datetime NULL,
    [UIE_LAST_MODIFIED_BY] int NULL,
    [UIE_PROPERTIES] nvarchar(max) NULL,
    [UIE_NAME] nvarchar(440) NULL,
    [UIE_DESCRIPTION] nvarchar(max) NULL,
    [UIE_TYPE] int NULL,
    CONSTRAINT [PK_PA_UI_ELEMENT] PRIMARY KEY ([UIE_ID]),
    CONSTRAINT [PA_UI_ELEMENT_CREATED_BY_USER_ID] FOREIGN KEY ([UIE_CREATED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_UI_ELEMENT_LAST_MODIFIED_BY_USER_ID] FOREIGN KEY ([UIE_LAST_MODIFIED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_UI_ELEMENT_PROJECT] FOREIGN KEY ([UIE_PROJECT_ID]) REFERENCES [PA_PROJECT] ([PRO_ID])
);
GO

CREATE TABLE [PA_USER_ROLE] (
    [URO_ID] int NOT NULL IDENTITY,
    [URO_PROJECT_ID] bigint NULL,
    [URO_USER_ID] int NULL,
    [URO_ROLE_ID] int NULL,
    CONSTRAINT [PK_PA_USER_ROLE] PRIMARY KEY ([URO_ID]),
    CONSTRAINT [PA_USER_ROLE_PROJECT] FOREIGN KEY ([URO_PROJECT_ID]) REFERENCES [PA_PROJECT] ([PRO_ID]),
    CONSTRAINT [PA_USER_ROLE_ROLE] FOREIGN KEY ([URO_ROLE_ID]) REFERENCES [PA_ROLE] ([ROL_ID]),
    CONSTRAINT [PA_USER_ROLE_USER] FOREIGN KEY ([URO_USER_ID]) REFERENCES [PA_USER] ([USR_ID])
);
GO

CREATE TABLE [PA_MODEL_ATTRIBUTE] (
    [MA_ID] bigint NOT NULL IDENTITY,
    [MA_MODEL_ID] bigint NOT NULL,
    [MA_TYPE] int NOT NULL,
    [MA_NAME] nvarchar(440) NOT NULL,
    [MA_DESCRIPTION] nvarchar(max) NULL,
    [MA_CONTENT] nvarchar(max) NOT NULL,
    [MA_CREATED_DATE] datetime NOT NULL,
    [MA_CREATED_BY] int NOT NULL,
    [MA_LAST_MODIFIED_DATE] datetime NOT NULL,
    [MA_LAST_MODIFIED_BY] int NOT NULL,
    CONSTRAINT [PK_PA_MODEL_ATTRIBUTE] PRIMARY KEY ([MA_ID]),
    CONSTRAINT [PA_MODEL_ATTRIBUTE_CREATED_BY_USER_ID] FOREIGN KEY ([MA_CREATED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_MODEL_ATTRIBUTE_LAST_MODIFIED_BY_USER_ID] FOREIGN KEY ([MA_LAST_MODIFIED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_MODEL_ATTRIBUTE_MODEL] FOREIGN KEY ([MA_MODEL_ID]) REFERENCES [PA_MODEL] ([MOD_ID]) ON DELETE CASCADE
);
GO

CREATE TABLE [PA_VIEW] (
    [VIE_ID] bigint NOT NULL IDENTITY,
    [VIE_MODEL_ID] bigint NULL,
    [VIE_NAME] nvarchar(max) NULL,
    [VIE_DESCRIPTION] nvarchar(max) NULL,
    [VIE_FLAGS] int NULL,
    [VIE_CREATED_DATE] datetime NULL,
    [VIE_CREATED_BY] int NULL,
    [VIE_LAST_MODIFIED_DATE] datetime NULL,
    [VIE_LAST_MODIFIED_BY] int NULL,
    [VIE_PUBLISH_MODE] int NULL,
    [VIE_CONFIGURATION] nvarchar(max) NULL,
    CONSTRAINT [PK_PA_VIEW] PRIMARY KEY ([VIE_ID]),
    CONSTRAINT [PA_VIEW_CREATED_BY] FOREIGN KEY ([VIE_CREATED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_VIEW_LAST_MODIFIED_BY] FOREIGN KEY ([VIE_LAST_MODIFIED_BY]) REFERENCES [PA_USER] ([USR_ID]),
    CONSTRAINT [PA_VIEW_MODEL] FOREIGN KEY ([VIE_MODEL_ID]) REFERENCES [PA_MODEL] ([MOD_ID])
);
GO

CREATE TABLE [PA_SCRIPT_PARAMETER] (
    [SCP_ID] bigint NOT NULL IDENTITY,
    [SCP_SCRIPT_ID] bigint NOT NULL,
    [SCP_TYPE] int NULL,
    [SCP_FLAGS] int NULL,
    [SCP_NAME] nvarchar(440) NULL,
    [SCP_DESCRIPTION] nvarchar(max) NULL,
    CONSTRAINT [PK_PA_SCRIPT_PARAMETER] PRIMARY KEY ([SCP_ID]),
    CONSTRAINT [PA_SCRIPT_PARAMETER_SCRIPT] FOREIGN KEY ([SCP_SCRIPT_ID]) REFERENCES [PA_SCRIPT] ([SCR_ID])
);
GO

CREATE TABLE [PA_USER_ATTRIBUTE] (
    [UAT_ID] bigint NOT NULL IDENTITY,
    [UAT_USER_ID] int NOT NULL,
    [UAT_MODEL_ID] bigint NULL,
    [UAT_PROJECT_ID] bigint NULL,
    [UAT_DASHBOARD_ID] bigint NULL,
    [UAT_KEY] nvarchar(440) NULL,
    [UAT_VALUE2] nvarchar(max) NOT NULL DEFAULT N'3',
    [UAT_VALUE] sql_variant NULL,
    [UAT_VALUE_STRING] nvarchar(max) NULL,
    CONSTRAINT [PK_PA_USER_ATTRIBUTE] PRIMARY KEY ([UAT_ID]),
    CONSTRAINT [PA_USER_ATTRIBUTE_DASHBOARD] FOREIGN KEY ([UAT_DASHBOARD_ID]) REFERENCES [PA_UI_ELEMENT] ([UIE_ID]) ON DELETE CASCADE,
    CONSTRAINT [PA_USER_ATTRIBUTE_MODEL] FOREIGN KEY ([UAT_MODEL_ID]) REFERENCES [PA_MODEL] ([MOD_ID]),
    CONSTRAINT [PA_USER_ATTRIBUTE_PROJECT] FOREIGN KEY ([UAT_PROJECT_ID]) REFERENCES [PA_PROJECT] ([PRO_ID]),
    CONSTRAINT [PA_USER_ATTRIBUTE_USER] FOREIGN KEY ([UAT_USER_ID]) REFERENCES [PA_USER] ([USR_ID])
);
GO

IF EXISTS (SELECT * FROM [sys].[identity_columns] WHERE [name] IN (N'CFG_ID', N'CFG_KEY', N'CFG_VALUE') AND [object_id] = OBJECT_ID(N'[PA_CONFIGURATION]'))
    SET IDENTITY_INSERT [PA_CONFIGURATION] ON;
INSERT INTO [PA_CONFIGURATION] ([CFG_ID], [CFG_KEY], [CFG_VALUE])
VALUES (1, N'DatabaseBulkCopyTimeout', '600'),
(2, N'DatabaseBulkCopyBatchSize', '5000'),
(3, N'DatabaseAvailabilityMode', '0'),
(4, N'SessionIdleTimeout', '3600'),
(5, N'SessionMaximumDuration', '86400'),
(6, N'DeleteModelsInRecycleBinOnStartup', '0'),
(7, N'SandboxDatabaseConnectionString', ''),
(8, N'SandboxDatabaseBulkCopyTimeout', '600'),
(9, N'SandboxDatabaseBulkCopyBatchSize', '5000'),
(10, N'StartupModelLoadingMaxParallelism', '2'),
(11, N'AllowExternalDatasources', 'true'),
(12, N'ServiceProviderLocation', ''),
(13, N'SAMLMetadataUrl', ''),
(14, N'SAMLUserIdAttribute', ''),
(15, N'SAMLEncryptionCertificate', ''),
(16, N'SAMLSigningCertificate', ''),
(17, N'DefaultUiLanguage', ''),
(18, N'NumberOfParallelModelReaders', '4'),
(19, N'AllowNonTemporaryETLTargetTable', 'false'),
(20, N'AuthenticationMethod', '1'),
(21, N'LDAPConnectionString', ''),
(22, N'LDAPUserFilter', ''),
(23, N'LDAPUserSearchBase', ''),
(24, N'LDAPUserIdAttributeName', ''),
(25, N'LDAPServerUserName', ''),
(26, N'LDAPServerPassword', ''),
(27, N'SmtpServer', ''),
(28, N'SmtpPort', '25'),
(29, N'SmtpAuthenticationUsername', ''),
(30, N'SmtpAuthenticationPassword', ''),
(31, N'SmtpEnableSSL', 'false'),
(32, N'SmtpFromAddress', ''),
(33, N'RedshiftConnectionString', ''),
(34, N'SqlServerConnectionString', ''),
(35, N'SnowflakeConnectionString', ''),
(36, N'QueryTimeout', '300'),
(37, N'DefaultDataSource', 'Snowflake'),
(38, N'OpenAIAPIKey', ''),
(39, N'OpenAIDefaultModelName', ''),
(40, N'CacheOnlyPrimaryKeysForFilters', '0'),
(41, N'DatabaseVersion', '106'),
(42, N'InitializationScriptDatabaseVersion', '106');
INSERT INTO [PA_CONFIGURATION] ([CFG_ID], [CFG_KEY], [CFG_VALUE])
VALUES (43, N'MinimumDatabaseVersion', '106');
IF EXISTS (SELECT * FROM [sys].[identity_columns] WHERE [name] IN (N'CFG_ID', N'CFG_KEY', N'CFG_VALUE') AND [object_id] = OBJECT_ID(N'[PA_CONFIGURATION]'))
    SET IDENTITY_INSERT [PA_CONFIGURATION] OFF;
GO

IF EXISTS (SELECT * FROM [sys].[identity_columns] WHERE [name] IN (N'ROL_ID', N'ROL_FLAGS', N'ROL_NAME') AND [object_id] = OBJECT_ID(N'[PA_ROLE]'))
    SET IDENTITY_INSERT [PA_ROLE] ON;
INSERT INTO [PA_ROLE] ([ROL_ID], [ROL_FLAGS], [ROL_NAME])
VALUES (1, 3, N'Administrator'),
(2, 1, N'ModelCreator'),
(3, 1, N'RunScripts'),
(4, 2, N'Designer'),
(5, 2, N'Analyzer'),
(6, 2, N'Viewer');
IF EXISTS (SELECT * FROM [sys].[identity_columns] WHERE [name] IN (N'ROL_ID', N'ROL_FLAGS', N'ROL_NAME') AND [object_id] = OBJECT_ID(N'[PA_ROLE]'))
    SET IDENTITY_INSERT [PA_ROLE] OFF;
GO

IF EXISTS (SELECT * FROM [sys].[identity_columns] WHERE [name] IN (N'USR_ID', N'USR_BLOCKED_DATE', N'USR_DESCRIPTION', N'USR_EMAIL', N'USR_FLAGS', N'USR_FULL_NAME', N'USR_LAST_LOGIN_DATE', N'USR_LOGON_NAME', N'USR_LOGIN_ATTEMPTS_COUNT', N'USR_PASSWORD_HASH') AND [object_id] = OBJECT_ID(N'[PA_USER]'))
    SET IDENTITY_INSERT [PA_USER] ON;
INSERT INTO [PA_USER] ([USR_ID], [USR_BLOCKED_DATE], [USR_DESCRIPTION], [USR_EMAIL], [USR_FLAGS], [USR_FULL_NAME], [USR_LAST_LOGIN_DATE], [USR_LOGON_NAME], [USR_LOGIN_ATTEMPTS_COUNT], [USR_PASSWORD_HASH])
VALUES (1, NULL, NULL, NULL, NULL, NULL, NULL, N'Administrator', NULL, N'JoqKyoDqMicuu0narinCyvHQ7Z2PuANZrnJEiqHsORzd3xzBDAutTdFE6EeqrHpr');
IF EXISTS (SELECT * FROM [sys].[identity_columns] WHERE [name] IN (N'USR_ID', N'USR_BLOCKED_DATE', N'USR_DESCRIPTION', N'USR_EMAIL', N'USR_FLAGS', N'USR_FULL_NAME', N'USR_LAST_LOGIN_DATE', N'USR_LOGON_NAME', N'USR_LOGIN_ATTEMPTS_COUNT', N'USR_PASSWORD_HASH') AND [object_id] = OBJECT_ID(N'[PA_USER]'))
    SET IDENTITY_INSERT [PA_USER] OFF;
GO

IF EXISTS (SELECT * FROM [sys].[identity_columns] WHERE [name] IN (N'ROP_ID', N'ROP_PERMISSION_ID', N'ROP_ROLE_ID') AND [object_id] = OBJECT_ID(N'[PA_ROLE_PERMISSION]'))
    SET IDENTITY_INSERT [PA_ROLE_PERMISSION] ON;
INSERT INTO [PA_ROLE_PERMISSION] ([ROP_ID], [ROP_PERMISSION_ID], [ROP_ROLE_ID])
VALUES (1, 1, 1),
(2, 2, 1),
(3, 3, 1),
(4, 4, 1),
(5, 5, 1),
(6, 6, 1),
(7, 7, 1),
(8, 9, 1),
(9, 10, 1),
(10, 11, 1),
(11, 12, 1),
(12, 13, 1),
(13, 14, 1),
(14, 16, 1),
(15, 17, 1),
(16, 4, 2),
(17, 1, 4),
(18, 2, 4),
(19, 4, 4),
(20, 6, 4),
(21, 17, 4),
(22, 1, 5),
(23, 6, 5),
(24, 17, 5),
(25, 1, 6),
(26, 15, 3);
IF EXISTS (SELECT * FROM [sys].[identity_columns] WHERE [name] IN (N'ROP_ID', N'ROP_PERMISSION_ID', N'ROP_ROLE_ID') AND [object_id] = OBJECT_ID(N'[PA_ROLE_PERMISSION]'))
    SET IDENTITY_INSERT [PA_ROLE_PERMISSION] OFF;
GO

IF EXISTS (SELECT * FROM [sys].[identity_columns] WHERE [name] IN (N'URO_ID', N'URO_PROJECT_ID', N'URO_ROLE_ID', N'URO_USER_ID') AND [object_id] = OBJECT_ID(N'[PA_USER_ROLE]'))
    SET IDENTITY_INSERT [PA_USER_ROLE] ON;
INSERT INTO [PA_USER_ROLE] ([URO_ID], [URO_PROJECT_ID], [URO_ROLE_ID], [URO_USER_ID])
VALUES (1, NULL, 1, 1),
(2, NULL, 3, 1);
IF EXISTS (SELECT * FROM [sys].[identity_columns] WHERE [name] IN (N'URO_ID', N'URO_PROJECT_ID', N'URO_ROLE_ID', N'URO_USER_ID') AND [object_id] = OBJECT_ID(N'[PA_USER_ROLE]'))
    SET IDENTITY_INSERT [PA_USER_ROLE] OFF;
GO

CREATE INDEX [PA_CONFIGURATION_KEY] ON [PA_CONFIGURATION] ([CFG_KEY]);
GO

CREATE INDEX [PA_INTEGRATION_TABLE_CREATED_BY] ON [PA_INTEGRATION_TABLE] ([ITA_CREATED_BY]);
GO

CREATE INDEX [PA_INTEGRATION_TABLE_LAST_IMPORT_BY] ON [PA_INTEGRATION_TABLE] ([ITA_LAST_IMPORT_BY]);
GO

CREATE INDEX [PA_INTEGRATION_TABLE_LAST_MODIFIED_BY] ON [PA_INTEGRATION_TABLE] ([ITA_LAST_MODIFIED_BY]);
GO

CREATE INDEX [PA_INTEGRATION_TABLE_PROJECT_ID] ON [PA_INTEGRATION_TABLE] ([ITA_PROJECT_ID]);
GO

CREATE UNIQUE INDEX [PA_INTEGRATION_TABLE_UNIQUE_NAME_IN_PROJECT] ON [PA_INTEGRATION_TABLE] ([ITA_PROJECT_ID], [ITA_NAME]) WHERE [ITA_NAME] IS NOT NULL;
GO

CREATE INDEX [PA_KEY_VALUE_STORE_PROJECT_ID] ON [PA_KEY_VALUE_STORE] ([KVS_PROJECT_ID]);
GO

CREATE INDEX [PA_MODEL_CREATED_BY] ON [PA_MODEL] ([MOD_CREATED_BY]);
GO

CREATE INDEX [PA_MODEL_LAST_MODIFIED_BY] ON [PA_MODEL] ([MOD_LAST_MODIFIED_BY]);
GO

CREATE INDEX [PA_MODEL_PROJECT_ID] ON [PA_MODEL] ([MOD_PROJECT_ID]);
GO

CREATE INDEX [PA_MODEL_ATTRIBUTE_CREATED_BY] ON [PA_MODEL_ATTRIBUTE] ([MA_CREATED_BY]);
GO

CREATE INDEX [PA_MODEL_ATTRIBUTE_LAST_MODIFIED_BY] ON [PA_MODEL_ATTRIBUTE] ([MA_LAST_MODIFIED_BY]);
GO

CREATE INDEX [PA_MODEL_ATTRIBUTE_MODEL_ID] ON [PA_MODEL_ATTRIBUTE] ([MA_TYPE], [MA_MODEL_ID]);
GO

CREATE UNIQUE INDEX [PA_MODEL_ATTRIBUTE_MODEL_ID_NAME] ON [PA_MODEL_ATTRIBUTE] ([MA_TYPE], [MA_MODEL_ID], [MA_NAME]);
GO

CREATE INDEX [PA_MODEL_ATTRIBUTE_MODEL_ID_ONLY] ON [PA_MODEL_ATTRIBUTE] ([MA_MODEL_ID]);
GO

CREATE INDEX [PA_OPERATION_STATUS_SESSION_ID] ON [PA_OPERATION_STATUS] ([OPE_SESSION_ID]);
GO

CREATE INDEX [PA_OPERATION_STATUS_START_TIME] ON [PA_OPERATION_STATUS] ([OPE_START_TIME]);
GO

CREATE INDEX [PA_OPERATION_STATUS_USER_ID] ON [PA_OPERATION_STATUS] ([OPE_USER_ID]);
GO

CREATE INDEX [PA_PROJECT_CREATED_BY] ON [PA_PROJECT] ([PRO_CREATED_BY]);
GO

CREATE INDEX [PA_PROJECT_DELETED_BY] ON [PA_PROJECT] ([PRO_DELETED_BY]);
GO

CREATE INDEX [PA_PROJECT_LAST_MODIFIED_BY] ON [PA_PROJECT] ([PRO_LAST_MODIFIED_BY]);
GO

CREATE INDEX [PA_PROJECT_PARENT_ID] ON [PA_PROJECT] ([PRO_PARENT_ID]);
GO

CREATE INDEX [PA_ROLE_PERMISSION_ROLE_ID] ON [PA_ROLE_PERMISSION] ([ROP_ROLE_ID]);
GO

CREATE INDEX [PA_SCRIPT_CREATED_BY] ON [PA_SCRIPT] ([SCR_CREATED_BY]);
GO

CREATE INDEX [PA_SCRIPT_LAST_MODIFIED_BY] ON [PA_SCRIPT] ([SCR_LAST_MODIFIED_BY]);
GO

CREATE INDEX [PA_SCRIPT_PROJECT] ON [PA_SCRIPT] ([SCR_PROJECT_ID]);
GO

CREATE INDEX [PA_SCRIPT_USER] ON [PA_SCRIPT] ([SCR_USER_ID]);
GO

CREATE INDEX [PA_SCRIPT_LOG_END_TIME] ON [PA_SCRIPT_LOG] ([SCL_END_TIME]);
GO

CREATE INDEX [PA_SCRIPT_LOG_OPERATION_ID] ON [PA_SCRIPT_LOG] ([SCL_OPERATION_ID]);
GO

CREATE INDEX [PA_SCRIPT_LOG_TYPE] ON [PA_SCRIPT_LOG] ([SCL_SCRIPT_ID], [SCL_TYPE]) INCLUDE ([SCL_OPERATION_ID]);
GO

CREATE INDEX [PA_SCRIPT_LOG_USER_ID] ON [PA_SCRIPT_LOG] ([SCL_USER_ID]);
GO

CREATE INDEX [PA_SCRIPT_PARAMETER_SCRIPT] ON [PA_SCRIPT_PARAMETER] ([SCP_SCRIPT_ID]);
GO

CREATE INDEX [PA_SESSION_FINISHED_DATE] ON [PA_SESSION] ([SES_FINISHED_DATE]);
GO

CREATE INDEX [PA_SESSION_SESSION_ID] ON [PA_SESSION] ([SES_SESSION_ID]);
GO

CREATE INDEX [PA_SESSION_USER_ID] ON [PA_SESSION] ([SES_USER_ID]);
GO

CREATE INDEX [PA_UI_ELEMENT_CREATED_BY] ON [PA_UI_ELEMENT] ([UIE_CREATED_BY]);
GO

CREATE INDEX [PA_UI_ELEMENT_LAST_MODIFIED_BY] ON [PA_UI_ELEMENT] ([UIE_LAST_MODIFIED_BY]);
GO

CREATE INDEX [PA_UI_ELEMENT_PROJECT_ID] ON [PA_UI_ELEMENT] ([UIE_PROJECT_ID]);
GO

CREATE INDEX [PA_UI_ELEMENT_TYPE] ON [PA_UI_ELEMENT] ([UIE_TYPE]);
GO

CREATE UNIQUE INDEX [PA_USER_UNIQUE_LOGON_NAME] ON [PA_USER] ([USR_LOGON_NAME]) WHERE [USR_LOGON_NAME] IS NOT NULL;
GO

CREATE INDEX [PA_USER_ATTRIBUTE_DASHBOARD_ID] ON [PA_USER_ATTRIBUTE] ([UAT_DASHBOARD_ID]);
GO

CREATE INDEX [PA_USER_ATTRIBUTE_KEY] ON [PA_USER_ATTRIBUTE] ([UAT_KEY]);
GO

CREATE INDEX [PA_USER_ATTRIBUTE_MODEL_ID] ON [PA_USER_ATTRIBUTE] ([UAT_MODEL_ID]);
GO

CREATE INDEX [PA_USER_ATTRIBUTE_PROJECT_ID] ON [PA_USER_ATTRIBUTE] ([UAT_PROJECT_ID]);
GO

CREATE INDEX [PA_USER_ATTRIBUTE_USER_ID] ON [PA_USER_ATTRIBUTE] ([UAT_USER_ID]);
GO

CREATE INDEX [PA_USER_GROUP_GROUP_ID] ON [PA_USER_GROUP] ([USG_GROUP_ID]);
GO

CREATE INDEX [PA_USER_GROUP_MEMBER_ID] ON [PA_USER_GROUP] ([USG_MEMBER_ID]);
GO

CREATE INDEX [PA_USER_ROLE_PROJECT_ID] ON [PA_USER_ROLE] ([URO_PROJECT_ID]);
GO

CREATE INDEX [PA_USER_ROLE_ROLE_ID] ON [PA_USER_ROLE] ([URO_ROLE_ID]);
GO

CREATE INDEX [PA_USER_ROLE_USER_ID] ON [PA_USER_ROLE] ([URO_USER_ID]);
GO

CREATE INDEX [PA_VIEW_CREATED_BY] ON [PA_VIEW] ([VIE_CREATED_BY]);
GO

CREATE INDEX [PA_VIEW_LAST_MODIFIED_BY] ON [PA_VIEW] ([VIE_LAST_MODIFIED_BY]);
GO

CREATE INDEX [PA_VIEW_MODEL_ID] ON [PA_VIEW] ([VIE_MODEL_ID]);
GO

INSERT INTO [PA_MIGRATION_HISTORY] ([MH_ID], [MH_EF_VERSION])
VALUES (N'20250113102046_B-08566', N'8.0.19');
GO

COMMIT;
GO

BEGIN TRANSACTION;
GO

DELETE FROM PA_SCRIPT WHERE SCR_PROJECT_ID IS NULL
GO

WITH MODEL_DUPLICATES_CTE(CTE_PROJECT_ID, CTE_NAME) AS
(
SELECT MOD_PROJECT_ID, MOD_NAME
FROM PA_MODEL
GROUP BY MOD_PROJECT_ID, MOD_NAME
HAVING COUNT(MOD_NAME) > 1
)
UPDATE PA_MODEL
SET MOD_NAME = MOD_NAME + ' ' + CAST(MOD_ID AS VARCHAR)
WHERE MOD_ID IN
(
SELECT B.MOD_ID
FROM MODEL_DUPLICATES_CTE A
INNER JOIN PA_MODEL B
ON A.CTE_PROJECT_ID = B.MOD_PROJECT_ID
AND A.CTE_NAME = B.MOD_NAME
);

WITH SCRIPT_DUPLICATES_CTE(CTE_PROJECT_ID, CTE_NAME) AS
(
SELECT SCR_PROJECT_ID, SCR_TITLE
FROM PA_SCRIPT
GROUP BY SCR_PROJECT_ID, SCR_TITLE
HAVING COUNT(SCR_TITLE) > 1
)
UPDATE PA_SCRIPT
SET SCR_TITLE = SCR_TITLE + ' ' + CAST(SCR_ID AS VARCHAR)
WHERE SCR_ID IN
(
SELECT B.SCR_ID
FROM SCRIPT_DUPLICATES_CTE A
INNER JOIN PA_SCRIPT B
ON A.CTE_PROJECT_ID = B.SCR_PROJECT_ID
AND A.CTE_NAME = B.SCR_TITLE
);

WITH DASHBOARD_DUPLICATES_CTE(CTE_PROJECT_ID, CTE_NAME) AS
(
SELECT UIE_PROJECT_ID, UIE_NAME
FROM PA_UI_ELEMENT
GROUP BY UIE_PROJECT_ID, UIE_NAME
HAVING COUNT(UIE_NAME) > 1
)
UPDATE PA_UI_ELEMENT
SET UIE_NAME = UIE_NAME + ' ' + CAST(UIE_ID AS VARCHAR)
WHERE UIE_ID IN
(
SELECT B.UIE_ID
FROM DASHBOARD_DUPLICATES_CTE A
INNER JOIN PA_UI_ELEMENT B
ON A.CTE_PROJECT_ID = B.UIE_PROJECT_ID
AND A.CTE_NAME = B.UIE_NAME
);
GO

CREATE UNIQUE INDEX [PA_UI_ELEMENT_UNIQUE_NAME_IN_PROJECT] ON [PA_UI_ELEMENT] ([UIE_PROJECT_ID], [UIE_NAME]) WHERE [UIE_PROJECT_ID] IS NOT NULL AND [UIE_NAME] IS NOT NULL;
GO

CREATE UNIQUE INDEX [PA_SCRIPT_UNIQUE_NAME_IN_PROJECT] ON [PA_SCRIPT] ([SCR_PROJECT_ID], [SCR_TITLE]) WHERE [SCR_PROJECT_ID] IS NOT NULL AND [SCR_TITLE] IS NOT NULL;
GO

UPDATE PA_MODEL SET [MOD_FLAGS] = 0 WHERE [MOD_FLAGS] IS NULL;
GO

DECLARE @var0 sysname;
SELECT @var0 = [d].[name]
FROM [sys].[default_constraints] [d]
INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
WHERE ([d].[parent_object_id] = OBJECT_ID(N'[PA_MODEL]') AND [c].[name] = N'MOD_FLAGS');
IF @var0 IS NOT NULL EXEC(N'ALTER TABLE [PA_MODEL] DROP CONSTRAINT [' + @var0 + '];');
UPDATE [PA_MODEL] SET [MOD_FLAGS] = 0 WHERE [MOD_FLAGS] IS NULL;
ALTER TABLE [PA_MODEL] ALTER COLUMN [MOD_FLAGS] int NOT NULL;
ALTER TABLE [PA_MODEL] ADD DEFAULT 0 FOR [MOD_FLAGS];
GO

CREATE UNIQUE INDEX [PA_MODEL_UNIQUE_NAME_IN_PROJECT] ON [PA_MODEL] ([MOD_PROJECT_ID], [MOD_NAME]) WHERE [MOD_PROJECT_ID] IS NOT NULL AND [MOD_NAME] IS NOT NULL AND [MOD_FLAGS] <> 1;
GO

INSERT INTO [PA_MIGRATION_HISTORY] ([MH_ID], [MH_EF_VERSION])
VALUES (N'20250524184110_D-09480', N'8.0.19');
GO

COMMIT;
GO

BEGIN TRANSACTION;
GO

ALTER TABLE [PA_USER] ADD [USR_DEFAULT_DASHBOARD] nvarchar(max) NULL;
GO

UPDATE [PA_USER] SET [USR_DEFAULT_DASHBOARD] = NULL
WHERE [USR_ID] = 1;
SELECT @@ROWCOUNT;

GO

INSERT INTO [PA_MIGRATION_HISTORY] ([MH_ID], [MH_EF_VERSION])
VALUES (N'20250819092738_B-08791', N'8.0.19');
GO

COMMIT;
GO

BEGIN TRANSACTION;
GO

ALTER TABLE [PA_USER] ADD [USR_CREATED_BY] int NULL;
GO

ALTER TABLE [PA_USER] ADD [USR_CREATED_DATE] datetime NULL;
GO

ALTER TABLE [PA_USER] ADD [USR_LAST_MODIFIED_BY] int NULL;
GO

ALTER TABLE [PA_USER] ADD [USR_LAST_MODIFIED_DATE] datetime NULL;
GO

update PA_USER set 
  USR_CREATED_BY=USR_ID, 
  USR_LAST_MODIFIED_BY=USR_ID, 
  USR_CREATED_DATE=GETDATE(), 
  USR_LAST_MODIFIED_DATE=GETDATE();
GO

DECLARE @var1 sysname;
SELECT @var1 = [d].[name]
FROM [sys].[default_constraints] [d]
INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
WHERE ([d].[parent_object_id] = OBJECT_ID(N'[PA_USER]') AND [c].[name] = N'USR_LAST_MODIFIED_DATE');
IF @var1 IS NOT NULL EXEC(N'ALTER TABLE [PA_USER] DROP CONSTRAINT [' + @var1 + '];');
UPDATE [PA_USER] SET [USR_LAST_MODIFIED_DATE] = GETDATE() WHERE [USR_LAST_MODIFIED_DATE] IS NULL;
ALTER TABLE [PA_USER] ALTER COLUMN [USR_LAST_MODIFIED_DATE] datetime NOT NULL;
ALTER TABLE [PA_USER] ADD DEFAULT (GETDATE()) FOR [USR_LAST_MODIFIED_DATE];
GO

DECLARE @var2 sysname;
SELECT @var2 = [d].[name]
FROM [sys].[default_constraints] [d]
INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
WHERE ([d].[parent_object_id] = OBJECT_ID(N'[PA_USER]') AND [c].[name] = N'USR_LAST_MODIFIED_BY');
IF @var2 IS NOT NULL EXEC(N'ALTER TABLE [PA_USER] DROP CONSTRAINT [' + @var2 + '];');
UPDATE [PA_USER] SET [USR_LAST_MODIFIED_BY] = 0 WHERE [USR_LAST_MODIFIED_BY] IS NULL;
ALTER TABLE [PA_USER] ALTER COLUMN [USR_LAST_MODIFIED_BY] int NOT NULL;
ALTER TABLE [PA_USER] ADD DEFAULT 0 FOR [USR_LAST_MODIFIED_BY];
GO

DECLARE @var3 sysname;
SELECT @var3 = [d].[name]
FROM [sys].[default_constraints] [d]
INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
WHERE ([d].[parent_object_id] = OBJECT_ID(N'[PA_USER]') AND [c].[name] = N'USR_CREATED_DATE');
IF @var3 IS NOT NULL EXEC(N'ALTER TABLE [PA_USER] DROP CONSTRAINT [' + @var3 + '];');
UPDATE [PA_USER] SET [USR_CREATED_DATE] = GETDATE() WHERE [USR_CREATED_DATE] IS NULL;
ALTER TABLE [PA_USER] ALTER COLUMN [USR_CREATED_DATE] datetime NOT NULL;
ALTER TABLE [PA_USER] ADD DEFAULT (GETDATE()) FOR [USR_CREATED_DATE];
GO

DECLARE @var4 sysname;
SELECT @var4 = [d].[name]
FROM [sys].[default_constraints] [d]
INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
WHERE ([d].[parent_object_id] = OBJECT_ID(N'[PA_USER]') AND [c].[name] = N'USR_CREATED_BY');
IF @var4 IS NOT NULL EXEC(N'ALTER TABLE [PA_USER] DROP CONSTRAINT [' + @var4 + '];');
UPDATE [PA_USER] SET [USR_CREATED_BY] = 0 WHERE [USR_CREATED_BY] IS NULL;
ALTER TABLE [PA_USER] ALTER COLUMN [USR_CREATED_BY] int NOT NULL;
ALTER TABLE [PA_USER] ADD DEFAULT 0 FOR [USR_CREATED_BY];
GO

CREATE INDEX [PA_USER_CREATED_BY] ON [PA_USER] ([USR_CREATED_BY]);
GO

CREATE INDEX [PA_USER_LAST_MODIFIED_BY] ON [PA_USER] ([USR_LAST_MODIFIED_BY]);
GO

ALTER TABLE [PA_USER] ADD CONSTRAINT [PA_USER_CREATED_BY] FOREIGN KEY ([USR_CREATED_BY]) REFERENCES [PA_USER] ([USR_ID]);
GO

ALTER TABLE [PA_USER] ADD CONSTRAINT [PA_USER_LAST_MODIFIED_BY] FOREIGN KEY ([USR_LAST_MODIFIED_BY]) REFERENCES [PA_USER] ([USR_ID]);
GO

INSERT INTO [PA_MIGRATION_HISTORY] ([MH_ID], [MH_EF_VERSION])
VALUES (N'20250903112341_B-08792-AuditFieldsForUserTable', N'8.0.19');
GO

COMMIT;
GO

